﻿© Fluke Calibration. All Rights Reserved.                   MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub NI PXI-4130 (1 yr) I Prog Acc Ch0 VER LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) I Prog Acc Ch1 VER LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) I Meas Acc Ch0 VER LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) I Meas Acc Ch1 VER LIB /8508
DATE:                  2011-10-24 12:19:14
AUTHOR:                Fluke
REVISION:              $Revision: 1.3 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       11
NUMBER OF LINES:       359
CONFIGURATION:         Fluke 8508A
=============================================================================
#
#  Text Source:
#    $RCSfile: sub_ni_pxi-4130_1yr_current_ver_lib_8508.txt,v $
#    $Date: 2011/10/24 19:19:58 $
#
#  Procedure Author:
#        DAC
#
#  Model(s) Covered:
#        PXI-4130
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Subprocedures:
#        Sub NI PXI-4130 (1 yr) Ch1 200 µA Prog Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 2 mA Prog Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 20 mA Prog Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 200 mA Prog Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 2 A Prog Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 200 µA Meas Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 2 mA Meas Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 20 mA Meas Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 200 mA Meas Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 2 A Meas Tests LIB /8508
#        Sub NI DC Power Setup LIB
#        Sub NI DC Power Output Off LIB
#
#  Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  MATH         @First = 1

  1.002  JMPL         CURRENT_PROGRAMMING_ACC_CH0  PSUBI("I Prog Acc Ch0")
  1.003  JMPL         CURRENT_PROGRAMMING_ACC_CH1  PSUBI("I Prog Acc Ch1")
  1.004  JMPL         CURRENT_MEASUREMENT_ACC_CH0  PSUBI("I Meas Acc Ch0")
  1.005  JMPL         CURRENT_MEASUREMENT_ACC_CH1  PSUBI("I Meas Acc Ch1")
  1.006  DISP         Subprocedure not found!
  1.007  END

  1.008  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) I Prog Acc Ch0 VER LIB /8508  ===============

  2.001  LABEL        CURRENT_PROGRAMMING_ACC_CH0
  2.002  MATH         @niDCPwrChan       = 0
  2.003  MATH         @niDCPwrVoltLvlRng = 6
  2.004  MATH         @niDCPwrVolt       = 6
  2.005  RSLT         =
  2.006  HEAD         {CURRENT PROGRAMMING ACCURACY}
  2.007  RSLT         =
  2.008  HEAD         -2{Channel 0: 1 A Range}
  2.009  MATH         @niDCPwrCurrLmtRng = 1
  2.010  RSLT         =
  2.011  RSLT         =+6 V

  2.012  MATH         @niDCPwrCurrLmt = 50E-3
  2.013  TARGET       -p
  2.014  DISP         Connect the UUT to the 8508A as follows:
  2.014  DISP
  2.014  DISP         [32]       UUT           8508A
  2.014  DISP         [32] Channel 0 High ---> INPUT A
  2.014  DISP         [32] Channel 0 Low ----> INPUT LO
  2.015  CALL         Sub NI DC Power Setup LIB
  2.016  WAIT         -t 3 Settling...
  2.017  TARGET       -m
  2.018  8508   1     0.050A         0.15% 0.004U                          2W

  3.001  MATH         @niDCPwrCurrLmt = 350E-3
  3.002  TARGET       -p
  3.003  CALL         Sub NI DC Power Setup LIB
  3.004  WAIT         -t 3 Settling...
  3.005  TARGET       -m
  3.006  8508   1     0.350A         0.15% 0.004U                          2W

  4.001  MATH         @niDCPwrCurrLmt = 700E-3
  4.002  TARGET       -p
  4.003  CALL         Sub NI DC Power Setup LIB
  4.004  WAIT         -t 3 Settling...
  4.005  TARGET       -m
  4.006  8508   1     0.700A         0.15% 0.004U                          2W

  5.001  HEAD         -2
  5.002  HEAD
  5.003  CALL         Sub NI DC Power Output Off LIB
  5.004  8508         *                                                 S
  5.005  END

  5.006  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) I Prog Acc Ch1 VER LIB /8508  ===============

  6.001  LABEL        CURRENT_PROGRAMMING_ACC_CH1
  6.002  HEAD         CURRENT PROGRAMMING ACCURACY
  6.003  MATH         @niDCPwrChan       = 1
  6.004  MATH         @niDCPwrVoltLvlRng = 20

  6.005  RSLT         =
  6.006  HEAD         -2{Channel 1: 200 µA Range}
  6.007  MATH         @niDCPwrCurrLmtRng = 200E-6
  6.008  RSLT         =
  6.009  RSLT         =+20 V
  6.010  MATH         @niDCPwrVolt = +20
  6.011  CALL         Sub NI PXI-4130 (1 yr) Ch1 200 µA Prog Tests LIB /8508

  6.012  RSLT         =
  6.013  RSLT         =-20 V
  6.014  MATH         @niDCPwrVolt = -20
  6.015  CALL         Sub NI PXI-4130 (1 yr) Ch1 200 µA Prog Tests LIB /8508

  6.016  RSLT         =
  6.017  HEAD         -2{Channel 1: 2 mA Range}
  6.018  MATH         @niDCPwrCurrLmtRng = 2E-3
  6.019  RSLT         =
  6.020  RSLT         =+20 V
  6.021  MATH         @niDCPwrVolt = +20
  6.022  CALL         Sub NI PXI-4130 (1 yr) Ch1 2 mA Prog Tests LIB /8508

  6.023  RSLT         =
  6.024  RSLT         =-20 V
  6.025  MATH         @niDCPwrVolt = -20
  6.026  CALL         Sub NI PXI-4130 (1 yr) Ch1 2 mA Prog Tests LIB /8508

  6.027  RSLT         =
  6.028  HEAD         -2{Channel 1: 20 mA Range}
  6.029  MATH         @niDCPwrCurrLmtRng = 20E-3
  6.030  RSLT         =
  6.031  RSLT         =+20 V
  6.032  MATH         @niDCPwrVolt = +20
  6.033  CALL         Sub NI PXI-4130 (1 yr) Ch1 20 mA Prog Tests LIB /8508

  6.034  RSLT         =
  6.035  RSLT         =-20 V
  6.036  MATH         @niDCPwrVolt = -20
  6.037  CALL         Sub NI PXI-4130 (1 yr) Ch1 20 mA Prog Tests LIB /8508

  6.038  RSLT         =
  6.039  HEAD         -2{Channel 1: 200 mA Range}
  6.040  MATH         @niDCPwrCurrLmtRng = 200E-3
  6.041  RSLT         =
  6.042  RSLT         =+20 V
  6.043  MATH         @niDCPwrVolt = +20
  6.044  CALL         Sub NI PXI-4130 (1 yr) Ch1 200 mA Prog Tests LIB /8508

  6.045  RSLT         =
  6.046  RSLT         =-20 V
  6.047  MATH         @niDCPwrVolt = -20
  6.048  CALL         Sub NI PXI-4130 (1 yr) Ch1 200 mA Prog Tests LIB /8508

  6.049  RSLT         =
  6.050  HEAD         -2{Channel 1: 2 A Range}
  6.051  MATH         @niDCPwrCurrLmtRng = 2
  6.052  RSLT         =
  6.053  RSLT         =+20 V
  6.054  MATH         @niDCPwrVolt = +20
  6.055  CALL         Sub NI PXI-4130 (1 yr) Ch1 2 A Prog Tests LIB /8508

  6.056  RSLT         =
  6.057  RSLT         =-20 V
  6.058  MATH         @niDCPwrVolt = -20
  6.059  CALL         Sub NI PXI-4130 (1 yr) Ch1 2 A Prog Tests LIB /8508

  6.060  HEAD         -2
  6.061  HEAD
  6.062  CALL         Sub NI DC Power Output Off LIB
  6.063  8508         *                                                 S
  6.064  END

  6.065  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) I Meas Acc Ch0 VER LIB /8508  ===============

  7.001  LABEL        CURRENT_MEASUREMENT_ACC_CH0
  7.002  MATH         @niDCPwrChan       = 0
  7.003  MATH         @niDCPwrVoltLvlRng = 6
  7.004  RSLT         =
  7.005  HEAD         {CURRENT MEASUREMENT ACCURACY}

  7.006  RSLT         =
  7.007  HEAD         -2{Channel 0: 1 A Range}
  7.008  MATH         @niDCPwrCurrLmtRng = 1

  7.009  RSLT         =
  7.010  RSLT         =0 V
  7.011  MATH         @niDCPwrVolt = 0

  7.012  MATH         @niDCPwrCurrLmt = 350E-3
  7.013  TARGET       -p
  7.014  CALL         Sub NI DC Power Setup LIB
  7.015  WAIT         -t 3 Settling...
  7.016  8508         0.350A                                         D5 N  2W
  7.017  MATH         SystemActual = MEM
  7.018  MATH         @Method = "NI DC Power Measure"
  7.019  TARGET       -m

  7.020  DO
  7.021  LIB          @Status = uut.niDCPower_Measure
  7.021  LIB          (@vi, @niDCPwrChan, @niDCPwrValMeasCurr, MEM);

  7.022  IF           @Status
  7.023  CALL         Sub NI DC Power Error Message LIB
  7.024  ENDIF

  7.025  UNTIL        (@Status == 0)

  7.026  MATH         MEM1 = SystemActual
  7.027  MEMCX  1     A              .15% .00400U

  8.001  RSLT         =
  8.002  RSLT         =6 V
  8.003  MATH         @niDCPwrVolt = 6
  8.004  TARGET       -p
  8.005  CALL         Sub NI DC Power Setup LIB
  8.006  WAIT         -t 3 Settling...
  8.007  8508         0.350A                                         D5 N  2W
  8.008  MATH         SystemActual = MEM
  8.009  MATH         @Method = "NI DC Power Measure"
  8.010  TARGET       -m

  8.011  DO
  8.012  LIB          @Status = uut.niDCPower_Measure
  8.012  LIB          (@vi, @niDCPwrChan, @niDCPwrValMeasCurr, MEM);

  8.013  IF           @Status
  8.014  CALL         Sub NI DC Power Error Message LIB
  8.015  ENDIF

  8.016  UNTIL        (@Status == 0)

  8.017  MATH         MEM1 = SystemActual
  8.018  MEMCX  1     A              .15% .00400U

  9.001  MATH         @niDCPwrCurrLmt = 700E-3
  9.002  TARGET       -p
  9.003  CALL         Sub NI DC Power Setup LIB
  9.004  WAIT         -t 3 Settling...
  9.005  8508         0.700A                                         D5 N  2W
  9.006  MATH         SystemActual =  MEM
  9.007  MATH         @Method = "NI DC Power Measure"
  9.008  TARGET       -m

  9.009  DO
  9.010  LIB          @Status = uut.niDCPower_Measure
  9.010  LIB          (@vi, @niDCPwrChan, @niDCPwrValMeasCurr, MEM);

  9.011  IF           @Status
  9.012  CALL         Sub NI DC Power Error Message LIB
  9.013  ENDIF

  9.014  UNTIL        (@Status == 0)

  9.015  MATH         MEM1 = SystemActual
  9.016  MEMCX  1     A              .15% .00400U

 10.001  HEAD         -2
 10.002  HEAD
 10.003  CALL         Sub NI DC Power Output Off LIB
 10.004  8508         *                                                 S
 10.005  END

 10.006  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) I Meas Acc Ch1 VER LIB /8508  ===============

 11.001  LABEL        CURRENT_MEASUREMENT_ACC_CH1
 11.002  HEAD         CURRENT MEASUREMENT ACCURACY
 11.003  MATH         @niDCPwrChan       = 1
 11.004  MATH         @niDCPwrVoltLvlRng = 20

 11.005  RSLT         =
 11.006  HEAD         -2{Channel 1: 200 µA Range}
 11.007  MATH         @niDCPwrCurrLmtRng = 200E-6
 11.008  RSLT         =
 11.009  RSLT         =+20 V
 11.010  MATH         @niDCPwrVolt = +20
 11.011  CALL         Sub NI PXI-4130 (1 yr) Ch1 200 µA Meas Tests LIB /8508

 11.012  RSLT         =
 11.013  RSLT         =-20 V
 11.014  MATH         @niDCPwrVolt = -20
 11.015  CALL         Sub NI PXI-4130 (1 yr) Ch1 200 µA Meas Tests LIB /8508

 11.016  RSLT         =
 11.017  HEAD         -2{Channel 1: 2 mA Range}
 11.018  MATH         @niDCPwrCurrLmtRng = 2E-3
 11.019  RSLT         =
 11.020  RSLT         =+20 V
 11.021  MATH         @niDCPwrVolt = +20
 11.022  CALL         Sub NI PXI-4130 (1 yr) Ch1 2 mA Meas Tests LIB /8508

 11.023  RSLT         =
 11.024  RSLT         =-20 V
 11.025  MATH         @niDCPwrVolt = -20
 11.026  CALL         Sub NI PXI-4130 (1 yr) Ch1 2 mA Meas Tests LIB /8508

 11.027  RSLT         =
 11.028  HEAD         -2{Channel 1: 20 mA Range}
 11.029  MATH         @niDCPwrCurrLmtRng = 20E-3
 11.030  RSLT         =
 11.031  RSLT         =+20 V
 11.032  MATH         @niDCPwrVolt = +20
 11.033  CALL         Sub NI PXI-4130 (1 yr) Ch1 20 mA Meas Tests LIB /8508

 11.034  RSLT         =
 11.035  RSLT         =-20 V
 11.036  MATH         @niDCPwrVolt = -20
 11.037  CALL         Sub NI PXI-4130 (1 yr) Ch1 20 mA Meas Tests LIB /8508

 11.038  RSLT         =
 11.039  HEAD         -2{Channel 1: 200 mA Range}
 11.040  MATH         @niDCPwrCurrLmtRng = 200E-3
 11.041  RSLT         =
 11.042  RSLT         =+20 V
 11.043  MATH         @niDCPwrVolt = +20
 11.044  CALL         Sub NI PXI-4130 (1 yr) Ch1 200 mA Meas Tests LIB /8508

 11.045  RSLT         =
 11.046  RSLT         =-20 V
 11.047  MATH         @niDCPwrVolt = -20
 11.048  CALL         Sub NI PXI-4130 (1 yr) Ch1 200 mA Meas Tests LIB /8508

 11.049  RSLT         =
 11.050  HEAD         -2{Channel 1: 2 A Range}
 11.051  MATH         @niDCPwrCurrLmtRng = 2
 11.052  RSLT         =
 11.053  RSLT         =+20 V
 11.054  MATH         @niDCPwrVolt = +20
 11.055  CALL         Sub NI PXI-4130 (1 yr) Ch1 2 A Meas Tests LIB /8508

 11.056  RSLT         =
 11.057  RSLT         =-20 V
 11.058  MATH         @niDCPwrVolt = -20
 11.059  CALL         Sub NI PXI-4130 (1 yr) Ch1 2 A Meas Tests LIB /8508

 11.060  HEAD         -2
 11.061  HEAD
 11.062  8508         *                                                 S
 11.063  END